#ifndef SCENE_H
#define SCENE_H

#pragma warning(disable:4786)
#include <list>
#include <algorithm>

#include <maya/MFnDagNode.h>
#include <maya/MFnSkinCluster.h>

using namespace std;

#include "rwcommon.h"
#include <rpskin.h>
#include "node.h"

typedef struct
{
    RwFrame *frame;
    RwInt32 tag;
} TagData;

typedef list<sceneNode *> sceneNodes;
typedef list<sceneNode *>::iterator nodeIt;

/* Class representing the hierarchy of the scene to be exported */
class exportScene
{
public:
    exportScene();
    ~exportScene();
    
    sceneNodes      *nodes;
    sceneNodes      *skinNodes;
    unsigned int    numAnimatedNodes;
    nodeIt          nodeIterator;
    unsigned int    nodeCounter;
    animKeys        rpSkinHierarchyKeys;
    animKeys        rpHAnimHierarchyKeys;
    int             tagOffset;
    int             rootMdtShape;

    unsigned int    lastChildIndex;
    RwMatrix        *nodeInvMatrices;
    RwUInt32        *nodeAnimFlags;
    RwInt32         *nodeTags;

    MStatus         exportDff(char *fileName);
    RpClump         *convertHierarchyToClump();
    void            preProcessHierarchy(int mdtNodeIndex);
    void            optimiseHierarchy();
    void            mergeNodes(sceneNodes *nodes);
    bool            canMergeNodes(sceneNode *node0, sceneNode *node1);
    void            unifyKeyframes();
    bool            optimiseSceneNode(nodeIt nodeIt0);
    void            removeSceneNode(nodeIt nodeIt0);
    void            processHierarchy(RwFrame *frame, RpClump *clump);
    void            processGeometry(RpClump *clump);
    void            processSkinnedShapes(RpClump *clump);
    int             findSelectedShape();
    int             findRootShape();
    bool            isShapeSelected(int mdtNodeIndex);
    void            initialiseMayaSdk();
    void            cleanupMayaSdk();
    void            intialiseGlobalSceneData();
    void            cleanupGlobalSceneData();
    float           calculateScaleToFactor();

    static MObject  skinClusterCallBack(MObject object, void *pData);
    static MObject  ikHandleCallBack(MObject object, void *pData);
    static MObject  blendShapeCallBack(MObject object, void *pData);
    static MObject  nurbsSurfaceCallBack(MObject object, void *pData);
    bool            addAnimToClump(int mdtNodeIndex, RpClump *clump, RwChar *animName);
};

/* General Functions */
MString ObjectName(MObject object);
RwFrame * _findTaggedFrame(RwFrame *frame, void *data);
RpAnimSequence *_rpAnimClumpAddSequenceCallback(RpAnimSequence *animSequence, void *data);
RwFrame *_rpAnimClumpAddAllSequencesCallBack(RwFrame *frame, void *data);
RpClump *_rpAnimClumpForAllFramesAddSequences(RpClump *clump);

#endif //SCENE_H